/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.datapack;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import io.github.noeppi_noeppi.libx.codec.CodecHelper;
import io.github.noeppi_noeppi.libx.datapack.DatapackHelper;
import io.github.noeppi_noeppi.libx.util.LazyValue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraftforge.forgespi.locating.IModFile;

public class DynamicElementDatapack
implements PackResources {
    private final String name;
    private final Supplier<InputStream> packMcmeta;
    @Nullable
    private final RegistryAccess registryAccess;
    private final Map<ResourceLocation, DataEntry<?>> entries;

    public DynamicElementDatapack(IModFile file, String id, @Nullable RegistryAccess registryAccess) {
        this.name = file.getFileName() + "/" + id;
        this.packMcmeta = DatapackHelper.generatePackMeta(file, "Dynamic element datapack: " + file.getFileName() + "/" + id);
        this.registryAccess = registryAccess;
        this.entries = new HashMap();
    }

    protected <T> void addEntry(ResourceLocation path, Codec<T> codec, Supplier<T> value) {
        this.entries.put(path, new DataEntry<T>(codec, new LazyValue<T>(value)));
    }

    @Nonnull
    public String m_8017_() {
        return this.name;
    }

    @Nullable
    public InputStream m_5542_(@Nonnull String fileName) throws IOException {
        return "pack.mcmeta".equals(fileName) ? this.packMcmeta.get() : null;
    }

    @Nonnull
    public InputStream m_8031_(@Nonnull PackType type, @Nonnull ResourceLocation location) throws IOException {
        if (type == PackType.CLIENT_RESOURCES) {
            throw new FileNotFoundException(type.m_10305_() + "/" + location);
        }
        if (this.entries.containsKey(location)) {
            return this.entries.get(location).access(this.registryAccess);
        }
        throw new FileNotFoundException(type.m_10305_() + "/" + location);
    }

    @Nonnull
    public Collection<ResourceLocation> m_7466_(@Nonnull PackType type, @Nonnull String namespace, @Nonnull String path, int maxDepth, @Nonnull Predicate<String> filter) {
        if (type == PackType.CLIENT_RESOURCES) {
            return List.of();
        }
        return this.entries.keySet().stream().filter(rl -> rl.m_135827_().equals(namespace)).filter(rl -> rl.m_135815_().startsWith(path + "/")).filter(rl -> {
            String[] parts = rl.m_135815_().split("/");
            return parts.length > 0 && parts.length <= maxDepth && filter.test(parts[parts.length - 1]);
        }).toList();
    }

    public boolean m_7211_(@Nonnull PackType type, @Nonnull ResourceLocation location) {
        return type == PackType.SERVER_DATA && this.entries.containsKey(location);
    }

    @Nonnull
    public Set<String> m_5698_(@Nonnull PackType type) {
        return this.entries.keySet().stream().map(ResourceLocation::m_135827_).collect(Collectors.toUnmodifiableSet());
    }

    @Nullable
    public <T> T m_5550_(@Nonnull MetadataSectionSerializer<T> deserializer) {
        return null;
    }

    public void close() {
    }

    private record DataEntry<T>(Codec<T> codec, LazyValue<T> value) {
        public InputStream access(@Nullable RegistryAccess registryAccess) throws IOException {
            T t = this.value().get();
            JsonElement elem = registryAccess == null ? CodecHelper.JSON.write(this.codec(), t) : CodecHelper.JSON.write(this.codec(), t, registryAccess);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
            writer.write(DatapackHelper.GSON.toJson(elem) + "\n");
            ((Writer)writer).close();
            out.close();
            return new ByteArrayInputStream(out.toByteArray());
        }
    }
}

